


/***********************************************************************************************
 *                                                                                             *
 *                     Example_2. ET-REMOTE MP3 COMMAND-Mode By Read Play Time                 *
 *                                                                                             *
 ***********************************************************************************************
 *                                                                                             *
 * Target MCU     : ATMEL AVR-MEGA128 (ET-BASE AVR atmega128 r3)                               *
 *                : X-TAL : 16 MHz                                                             * 
 *                                                                                             *
 * Editor         : AVR Studio 4.15 Build 623                                                  *
 * Compiler       : WinAVR-20081205                                                            *
 *                                                                                             *
 * Port Interface :                                                                            *
 *                                                                                             *
 *                : # MCU-MEGA128 #               # ET-REMOTE MP3 V2 #                         *
 *                  --------------                --------------------                         *
 *          UART0 :    PE0(RX0)        Connect        Tx                                       *
 *                     PE1(TX0)        Connect        Rx                                       *
 *                     GND             Connect        GND                                      *
 *                     BAUD RATE 9600                                                          *  
 *              5V                                                                             *
 *             -+-                                                                             *
 *              |                                                                              *
 *              +------------------+                                                           *
 *              |                  |                                      -DIF SW.MODE         *
 *              |                  |                                       S1=ON  ; S2=ON      *
 *              |                  |                 ET-REMOTE MP3 V2     -DIP SW.CONFIG       *
 *       +------+------+           |               +-------------------+   S1=ON  ; S2=OFF     *
 *       |             |       +---+---+   +---+   |                   |   BR:9600             *
 *       |             |       |       |   |   |   |RS232(have-Max232) |                       *
 *       |             | RX0   |       |   |   |   |----+              |                       *
 *       |          PE0+-------|RxI RxO|<--|-+ +-->|*Rx||              |        /|             *   
 *       |             | TX0   |       |   | |     |   ||              |      /  |             *
 *       |          PE1+-------|TxI TxO|---+ +-----|*Tx||              +----||   |             *
 *       |             |       |       |           |   ||              |    || SP|             *
 *       |             |       |MAX232 |       +---+*G ||              +----||   |             *
 *       |             |       +---+---+       |   |----+   [Power]    |      \  |             *
 *       | AVR Mega 128|           |           |   |                   |        \|             * 
 *       +------+------+           |           |   |         G  5V     |                       *
 *              |                  |           |   +---------+---+-----+                       * 
 *              |                  |           |             |   |                             *
 *              +------------------+-----------+             |   +--->5V                       *
 *              |                                            |                                 *
 *            --+--                                        --+--                               *
 *             ---                                          ---                                *
 *              -                                            -                                 *
 *                                                                                             *
 * Test Operate    : For Test Program in Micro SD Card must have File Name 'A23_FT1.MP3' and   *
 *                   'A23_FT2.MP3' ;... Begin Set Command For Show play Time then Play File    *
 *                   Name 'A23_FT1.MP3' is time 30 sec. and chang play File Name               *
 *                   'A24_FT2.MP3' is time 1 minute ,Then Return play New first file           *
 *                                                                                             *
 * Last Update     : 28/May/2012                                                               *  
 * Create By       : Mr. Sittiphol Yooyod (WWW.ETT.CO.TH)                                      *
 *                                                                                             *
 ***********************************************************************************************/





#include <stdio.h>
#include <avr/io.h>                  //define port
#include <compat/deprecated.h>       //call function sbi(port,bit),cbi(port,bit) = Set,Clear bit


#define F_CPU 16000000UL             //CPU Clock Frequency (Hz)
#include <util/delay.h>              //call function delay

unsigned char Buf_Time[5]  ;               


/*****************************************
 **         Function Delay ms           **
 *****************************************/

 void delay_ms(unsigned int cnt)
  {
    for(;cnt>0;cnt--)
       _delay_ms(1);
  }



/***************************************************************
 **                 Function use For Printf(UART0)            **
 ***************************************************************/


//--------------------- Prototype function ---------------------

static int uart_putchar(char c,FILE *stream) ;
static FILE uart_str = FDEV_SETUP_STREAM(uart_putchar,NULL,_FDEV_SETUP_WRITE);
void Init_Serial(unsigned int baudrate);


//----------------------- UART0 Putchar -------------------------

static int uart_putchar(char c,FILE *stream)
 {
   if(c=='\a')
     {
     fputs("*ring*\n",stderr) ;
     return 0 ;
     }
   
   if(c=='\n')
     uart_putchar('\r',stream) ;

   loop_until_bit_is_set(UCSR0A,UDRE);
   UDR0 = c ;

   return 0 ;
 }


//------------------- Initial UART0 -----------------------

static void UART0_Init(void)
 {

   UCSR0B = 0x00      ;     //disable while setting baud rate
   UBRR0H = 0         ;
   UBRR0L = 103       ;     //Set Baud Rate 9600
  
   UCSR0C = 0x06      ;     //Set Frame format : 8data,NoneParity,1stop bit
   UCSR0B = 0x98      ;     //Uart0 Control Enable Reciver and transmitter and INT.Rx

   stdout = &uart_str ;     //Set address uart_str to stdout

   

 }



//---------- Check Respond Command & End of Fili From Board MP3 -----------------
 

//-------------- Check Echo Command (#OK)----------------

void Echo_Cmm()
 {
   unsigned char buf_cmm[2] ;
   unsigned char n,ch ;
   
   do
    {
      do
       {
         loop_until_bit_is_set(UCSR0A,RXC)       ; //Check data in Rx_buffer
         ch = UDR0                               ; //Read data Start Byte
       }while(ch != '#')                         ; //Check Byte Start of Echo cmm('#')

      for(n=0;n<2;n++)                             //if ch = # then Keep cmm 2 byte(Keep 'OK')
       {
         loop_until_bit_is_set(UCSR0A,RXC)       ; //Check data in Rx_buffer
         buf_cmm[n] = UDR0                       ; //Read Data 'OK' 
       }
     
    }while((buf_cmm[0]!='O')||(buf_cmm[1]!='K')) ; //Check Echo Command = 'OK' Exit Loop
 }




//----------------- Read Play Time -------------------//
//           Buf_Time[0] = Ascii Minute Byte High     //
//           Buf_Time[1] = Ascii Minute Byte Low      //
//           Buf_Time[2] = Ascii :                    //
//           Buf_Time[3] = Ascii Secound Byte High    //
//           Buf_Time[4] = Ascii Secound Byte Low     //
//----------------------------------------------------//


void RD_Time()
 {
    unsigned char ch,n ;

      do
       {
         loop_until_bit_is_set(UCSR0A,RXC)       ; //Check data in Rx_buffer
         ch = UDR0                               ; //Read data Start Byte
       }while(ch !='@')                          ; //Check Byte Start of Echo cmm('@')

      for(n=0;n<5;n++)                             //if ch = @ then Keep data 5 byte(MM:SS)
       {
         loop_until_bit_is_set(UCSR0A,RXC)       ; //Check data in Rx_buffer
         Buf_Time[n] = UDR0                      ; //Read Data 'MM:SS' 
       }   


 }


/**********************************************************************
 **                                                                  **
 **                         main Program                             **
 **                                                                  **
 **********************************************************************/
 
 int main(void) 
  {
    unsigned char enter=0x0D  ;


    UART0_Init()      ;
    delay_ms(500)     ;  //delay for Sync Borad MP3 Ready 

    //------------------- Begin Sent Command --------------------

   printf("*CF=001%c",enter)     ;   //Sent CMM Config. Play[000] =0:Play Instantly ,0:Play 1 Round ,1: Display Time
   Echo_Cmm()                    ;   //Check CMM'#OK'

    

   //------------- Loop Play file by Name -----------
    
  
   while(1)
     {
      printf("*P2=A23_FT1.MP3%c",enter)      ;   //Sent CMM Play File by Name : 'A23_FT1.MP3'
      Echo_Cmm()                             ;   //Check CMM'#OK'
	  
	  do
	  {
	    RD_Time()                            ;  //Read Playing Time
	     
      }while((Buf_Time[0]!='0')||(Buf_Time[1]!='0')||(Buf_Time[3]!='3')||(Buf_Time[4]!='0'))  ;  //Check Play File to 00.30 sec. Give Chang play File    
	  
	

      printf("*P2=A24_FT2.MP3%c",enter)      ;   //Sent CMM Play File by Name : 'A24_FT2.MP3'
      Echo_Cmm()                             ;   //Check CMM'#OK'

      do
	  {
	    RD_Time()                            ;   //Read Playing Time
        
      }while((Buf_Time[0]!='0')||(Buf_Time[1]!='1')||(Buf_Time[3]!='0')||(Buf_Time[4]!='0'))  ; //Check Play File to 01.00 minit. Give Chang play File      
	
	
	}  // Return Play File New


  }



